<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?> >
<head profile="http://gmpg.org/xfn/11">
<title><?php wp_title(" | ",true,"right");?> <?php bloginfo('name'); ?></title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="cache-control" content="no-cache" />
<link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>" />
<link rel="shortcut icon" href="<?php bloginfo('template_url'); ?>/favicon.ico" type="image/x-icon" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php 
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	wp_head(); 
?>
</head>
<body <?php body_class(); ?>>
	<a id="top" name="top" />
	<div id="sky">
    	<div id="bubble">
			<div class="header">
				<div class="fleft">
					<a href="<?php bloginfo('url'); ?>" title="<?php printf(esc_attr( get_bloginfo( 'name', 'display' )) ); ?>" rel="home">
						<?php $siteLogo = get_theme_mod('hd_theme_logo');?>
						<?php if ($siteLogo): ?>
						<img class="png" id="global_logo" alt="<?php printf(esc_attr(get_bloginfo('name'))); ?>" src="<?php printf($siteLogo)?>">
						<?php else: ?>
						<img class="png" id="global_logo" alt="<?php printf(esc_attr(get_bloginfo('name'))); ?>" src="<?php bloginfo('template_directory'); ?>/images/logo.png">
						<?php endif;?>
					</a>
					<a href="<?php bloginfo('url'); ?>">
						<h1><?php bloginfo('description'); ?></h1>
					</a>
				</div>
				<div class="topform">
					<ul>
						<li class="fright"><a title="Subscribe RSS Feed" target="_blank" href="<?php bloginfo('rss_url'); ?>"><img class="png" alt="Subscribe RSS Feed " src="<?php bloginfo('template_directory'); ?>/images/ticon_rss.png"></a></li>
					
						<?php $hdTitterURL = esc_url(get_theme_mod("hd_theme_twitter_url", null)); ?>
						<?php if ($hdTitterURL != null): ?>
						<li class="fright"><a title="Follow us on Twitter" target="_blank" href="<?php printf($hdTitterURL); ?>"><img class="png" alt="Follow us on Twitter" src="<?php bloginfo('template_directory'); ?>/images/ticon_twitter.png"></a></li>
						<?php endif; ?>
						
						<?php $hdFacebookURL = esc_url(get_theme_mod("hd_theme_facebook_url", null)); ?>
						<?php if ($hdFacebookURL != null): ?>
						<li class="fright"><a title="Facebook" target="_blank" href="<?php printf($hdFacebookURL); ?>"><img class="png" alt="Facebook" src="<?php bloginfo('template_directory'); ?>/images/ticon_fb.png"></a></li>
						<?php endif; ?>
						
					</ul>
					
					<div class="global_search">
						<?php get_search_form(); ?>
					</div>
				</div>
			</div>
        </div>
    </div>

	<div class="wrapper">
		<div class="content_holder">
			
			<div class="block">
					<i class="gr ne"></i><i class="gr nw"></i><i class="gr se"></i><i class="gr sw"></i>
					<div  class="global_navigation">
						<?php if (function_exists('register_nav_menus')): wp_nav_menu( array( 'container'=>false, 'theme_location' => 'primary', 'depth' => 1 ) ); ?>
						<?php else: ?>
							<ul>
								<li<?php if ( is_front_page() ) echo ' class="current-menu-item"'; ?>><a href="<?php bloginfo('url'); ?>/"><span>Home</span></a></li>
								<?php wp_list_pages('sort_column=menu_order&title_li=&echo=1');	?>
							</ul>
						<?php endif; ?>
					</div>
			</div>
			
			
			            