<?php
if ( ! isset( $content_width ) )
	$content_width = 980;

if (function_exists('add_theme_support')) {
	add_theme_support( 'menus' );
}

if (function_exists('register_nav_menus')) {
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'hdtheme' ),
		'footer' => __( 'Footer Links', 'hdtheme' )
	) );
}


register_sidebars(1, array(
	'before_widget' => '<div id="%1$s" class="widget %2$s block block_header"><i class="gr ne"></i><i class="gr nw"></i><i class="gr se"></i><i class="gr sw"></i>',
	'after_widget' => '</div>',
	'before_title' => '<h3 class="lighter">',
	'after_title' => '</h3>',
));


// Add default posts and comments RSS feed links to head
add_theme_support( 'automatic-feed-links' );

function highdef_comment($comment, $args, $depth){
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
?>	
	<div <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<div class="c_holder">
			<?php echo get_avatar( $comment, 40 ); ?>
			<div class="cauthor">
				<cite class="date">
					<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>"><?php comment_date('F jS, Y') ?> at <?php comment_time() ?></a><?php edit_comment_link('edit',' | ') ?>
				</cite>
				<?php echo get_comment_author_link() ?>
			</div>
			<div class="con"><?php comment_text() ?></div>
			<?php if ($comment->comment_approved == '0') : ?>
			<p><em style="font-style:normal; color:#FF0000;">Your comment is awaiting moderation.</em></p>
			<?php endif; ?>
			
		</div>
	</div>
<?php
		break;
	endswitch;
}

/* 
 * overwrite archives widget
 */
add_filter('sidebars_widgets', 'sidebars_widgets');
function sidebars_widgets($sidebars_widgets) {
	global $wp_registered_widgets;
    foreach($sidebars_widgets as $idx => $widgets){
    	if($idx=='wp_inactive_widgets'){
    		continue;
    	}else{
    		foreach($widgets as $widget){
    			if(strpos($widget,"archives-")!==false){
					wp_register_sidebar_widget($widget, "Archives", 'widget_archives', null,array('title'=>'ccc'));
					$control_ops = array('width' => 200, 'height' => 350);
					wp_register_widget_control($widget, "Archives", 'widget_archives_control', $control_ops, array('title' => get_theme_mod('hd_theme_archive_title')));
    				break 2;
    			}
    		}
    	}
    }
    return $sidebars_widgets;
}


function widget_archives($args){
	printf($args['before_widget']) ;
	if (get_theme_mod('hd_theme_archive_title'))
	printf($args['before_title'].get_theme_mod('hd_theme_archive_title','Archives').$args['after_title']);
	printf('<ul id="tree">');
	printf(hd_category_archive());
	printf($args['after_widget']);
	printf('</ul>');
}


function widget_archives_control($widget_args) {
	global $wp_registered_widgets;
	static $updated = false;
	
	if(!$updated && !empty($_POST['sidebar'])) {
		$widget_args['title'] = $_POST['hd-theme-archive-title'];
		set_theme_mod('hd_theme_archive_title', $widget_args['title']);
	}
?>
	<p><label for="hd-theme-archive-title">Title:
	<input id="hd-theme-archive-title" name="hd-theme-archive-title" type="text" value="<?php printf($widget_args['title'])?>" style="width:100%;" /></label></p>
<?php
}



/*
 * category archives functions
 */
function category_month_archive($cat=''){
	global $wpdb;
	
	if($cat=='')
		$years = $wpdb->get_col("SELECT DISTINCT YEAR(post_date) FROM $wpdb->posts WHERE post_status = 'publish' AND post_type = 'post' ORDER BY post_date DESC");
	else
		$years = $wpdb->get_col("SELECT DISTINCT YEAR(post_date) FROM $wpdb->posts,$wpdb->term_taxonomy,$wpdb->term_relationships WHERE $wpdb->posts.post_status='publish' and $wpdb->posts.post_type='post' and $wpdb->term_taxonomy.term_id = $cat and 
							 $wpdb->term_taxonomy.taxonomy = 'category' and 
							 $wpdb->term_relationships.term_taxonomy_id = $wpdb->term_taxonomy.term_taxonomy_id and
							 $wpdb->term_relationships.object_id = wp_posts.ID
							  ORDER BY post_date DESC ");
	  
	$archive = array();
	
	foreach((array)$years as $year) :
		$archive[$year] = array('post_num'=>0,'month'=>array());
		$months = $wpdb->get_col("SELECT DISTINCT MONTH(post_date) FROM $wpdb->posts WHERE post_status = 'publish' AND post_type = 'post' AND YEAR(post_date) = '".$year."' ORDER BY post_date DESC");
		foreach((array)$months as $month) :
			$post_num = $wpdb->get_col("SELECT count(*) as f FROM $wpdb->posts WHERE post_status = 'publish' AND post_type = 'post' AND MONTH(post_date)= '".$month."' AND YEAR(post_date) = '".$year."' ORDER BY post_date ASC");
	        if($post_num[0]>0):
	        	$archive[$year]['month'][$month] = $post_num[0];
	        	$archive[$year]['post_num'] += $post_num[0];
	        endif;
		endforeach;
		if($archive[$year]['post_num']==0) unset($archive[$year]);
	endforeach; 
	
	return $archive;
}



function hd_category_archive($cat=''){
	$archive = category_month_archive($cat);
	$archive_html = '';
	foreach((array)$archive as $year => $year_info):
		$archive_html .= '<li>
							<a href="'.get_year_link($year).'" onclick="return false;" style="cursor:default"><cite>'.$year_info['post_num'].'</cite>'.$year.'</a>
							<ul>';
		foreach((array)$year_info['month'] as $month => $post_num):
			$archive_html .= '	<li><a href="'.get_month_link($year, $month).'"><cite>'.$post_num.'</cite>'.date( 'F', mktime(1, 1, 1, $month,1) ).'</a></li>';
		endforeach;
		$archive_html .= '	</ul>
						  </li>';
	endforeach;
	return $archive_html;
}



/*
 * Theme config in admin panel
 */
add_action('admin_menu', 'theme_config_menu');

function theme_config_menu() {
	add_theme_page('HD Theme Configuration', 'HD Theme Config', 'edit_theme_options', 'hd-theme-config', 'theme_config');
}

function theme_config(){
	$facebookURL = get_theme_mod('hd_theme_facebook_url');
	$twitterURL = get_theme_mod('hd_theme_twitter_url');
	
	$showHide = get_theme_mod('hd_theme_about_blog_show', null);
	
	$aboutBlogTitle = get_theme_mod('hd_theme_about_blog_title');
	
	$imageURL = get_theme_mod('hd_theme_about_blog_image');
	$logoURL = get_theme_mod('hd_theme_logo');
	$aboutContent = get_theme_mod('hd_theme_about_blog_content');
	
	$message = '';
	
	if(isset($_POST['submit'])){
		if (isset($_POST['facebook'])) $facebookURL = $_POST['facebook'];
		if (isset($_POST['twitter'])) $twitterURL = $_POST['twitter'];
		if (isset($_POST['about_this_blog_title'])) $aboutBlogTitle = $_POST['about_this_blog_title'];
		
		set_theme_mod('hd_theme_facebook_url', esc_url_raw($facebookURL));
		set_theme_mod('hd_theme_twitter_url', esc_url_raw($twitterURL));
		set_theme_mod('hd_theme_about_blog_title', $aboutBlogTitle);
		
		$showHide = $_POST['about_this_blog_show'];
		$aboutContent = $_POST['about_this_blog_content'];
		

		$aboutThisBlogImageRemove = array_key_exists('about_this_blog_image_remove', $_POST) ? $_POST['about_this_blog_image_remove'] : 0;
		$logoRemove = array_key_exists('logo_remove', $_POST) ? $_POST['logo_remove'] : 0;
		
		set_theme_mod('hd_theme_about_blog_show', $showHide);
		set_theme_mod('hd_theme_about_blog_content', $aboutContent);
		
		if ($aboutThisBlogImageRemove) {
			set_theme_mod('hd_theme_about_blog_image', '');
			$imageURL = '';
		} elseif (array_key_exists('about_this_blog_image', $_FILES) && !empty($_FILES['about_this_blog_image']['name'])) {
			$imageURL = hd_upload_image('about_this_blog_image');
			set_theme_mod('hd_theme_about_blog_image', $imageURL);
		}
		
		if ($logoRemove) {
			set_theme_mod('hd_theme_logo', '');
			$logoURL = '';
		} elseif (array_key_exists('logo', $_FILES) && !empty($_FILES['logo']['name'])) {
			$logoURL = hd_upload_image('logo');
			set_theme_mod('hd_theme_logo', $logoURL);
		}
		
		$message = '<div class="updated fade below-h2" id="message"><p>Theme options are saved.</p></div>';
	}
?>
	<div class="wrap">
		<div id="icon-options-general" class="icon32"><br /></div> 
	    <h2>HD Theme Configurations</h2> 
	    
		<?php if (!empty($message)) printf($message); ?>
		<form method="POST" enctype="multipart/form-data" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
		
			<h3>Site Logo</h3>
			<table class="form-table">
				<tr>
					<th><label for="logo">Logo:</label></th>
					<td>
						<input type="file" name="logo" id="logo" /> <br />
						<?php if (!empty($logoURL)): ?>
							<img src="<?php printf(esc_attr($logoURL))?>" /><br /><input type="checkbox" name="logo_remove" id="logo_remove" value="1"/> <label for="logo_remove">Remove</label><br />If logo is removed, you must specify the logo location by updating the theme file(header.php).
						<?php endif; ?>
					</td>
				</tr>
			</table>

			<br />
			<br />
			<h3>Social Links</h3>
			
			<table class="form-table">
				<tr>
					<th><label for="facebook">Facebook URL:</label></th>
					<td><input type="text" id="facebook" size="30" name="facebook" class="regular-text" value="<?php printf(esc_attr($facebookURL))?>" /></td>
				</tr>
				<tr>
					<th><label for="twitter">Twitter URL:</label></th>
					<td><input type="text" id="twitter" size="30" name="twitter" class="regular-text" value="<?php printf(esc_attr($twitterURL))?>" /></td>
				</tr>
			</table>
		
			<br />
			<br />
			<h3>About This Blog - Sidebar Widget</h3>
			
			<table class="form-table">
				<tr>
					<th><label for="about_this_blog_show">Show / Hide:</label></th>
					<td><select name="about_this_blog_show" id="about_this_blog_show"> <option value="1" <?php selected( $showHide , 1 ); ?> > Show </option><option value="0" <?php selected( $showHide , 0 ); ?>> Hide </option> </select> </td>
				</tr>
				<tr>
					<th><label for="about_this_blog_title">Widget Title:</label></th>
					<td><input type="text" id="about_this_blog_title" size="20" name="about_this_blog_title" class="regular-text" value="<?php printf(esc_attr($aboutBlogTitle))?>" /></td>
				</tr>
				<tr>
					<th><label for="about_this_blog_image">Image: (optional)<br /></label></th>
					<td>
						<input type="file" name="about_this_blog_image" id="about_this_blog_image" /> <br />
						(Image width should not more than 210px) <br />
						<?php if (!empty($imageURL)): ?>
							<img src="<?php printf($imageURL)?>" /><br /><input type="checkbox" name="about_this_blog_image_remove" id="about_this_blog_image_remove" value="1" > <label for="about_this_blog_image_remove">Remove</label>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<th><label for="about_this_blog_content">Content:</label></th>
					<td><textarea name="about_this_blog_content" id="about_this_blog_content" class="regular-textarea" cols="40" rows="3"><?php printf(esc_textarea($aboutContent))?></textarea></td>
				</tr>
			</table>
			<p class="submit"><input class="button-primary" type="submit" name="submit" value=" Save options " /></p>
		</form>
	</div>
<?php 
}


function hd_upload_image($file){
	$wp_upload = wp_upload_dir();
 	$upload_dir = $wp_upload['basedir'];
	$upload_file = trailingslashit($upload_dir) . basename($_FILES[$file]['name']);
	if( move_uploaded_file($_FILES[$file]['tmp_name'], $upload_file) ){
		chmod($upload_file, 0777);				
		$logo = $_FILES[$file]['name'];			
		return $wp_upload['baseurl'] ."/". $logo;
	}else{
		return '';
	}		 
}
?>